#if !defined _PCMag_ODBC_MSSQL_MSSQL_H_
#define _PCMag_ODBC_MSSQL_MSSQL_H_

// set _USE_SPS_ to TRUE to use stored procedures in the OLTP_Read_Select and DSS_Select queries
#define _USE_SPS_ FALSE

// set to TRUE to add extra test mixes to the benchmark
#define _EXTRA_MIXES_ TRUE

// set _ORASKIP_ to TRUE to skip certain queries Oracle is very slow at executing
#define _ORASKIP_ FALSE

// Benchmark Factory include files
#include "CSSBFC.h"
#include "CSSBenchmark.h"
#include "ctimer.h"
#include "BFC_ODBC.h"

// declare and initialize constants
const SQLINTEGER NUM_ROWS = 1;				// fetch rows in 1 row blocks (need this to be 1 to avoid mysterious slowdowns and return data truncation)

// define transaction class IDs
const int XID_OLTP_READ_SELECT = 1000;
const int XID_OLTP_READ_JOIN = 1100;
const int XID_OLTP_WRITE = 1200;
const int XID_DSS_SELECT = 1300;

// group names for transaction groups
enum
{
	OLTPReadSelect,
	OLTPReadJoin,
	OLTPWrite,
	DSSSelect
};

class AFX_EXT_CLASS PCMag_ODBC_MSSQL : public CSSBenchmark
{
	DECLARE_SERIAL(PCMag_ODBC_MSSQL)

public:

	PCMag_ODBC_MSSQL (void);
	~PCMag_ODBC_MSSQL (void);
	virtual BOOL RegisterTransactions(BOOL bRegisterObjectXact = FALSE);
};

// macros
#define CHECK_FOR_ERROR \
	if (ReturnCode != SQL_SUCCESS) { \
		m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes); \
		pSQLDatabaseServer->HandleError(hstmt); \
		if (hstmt != NULL) SQLFreeHandle (SQL_HANDLE_STMT,hstmt); \
		return FALSE; \
	}
#define CHECK_FOR_ERROR_EXECUTE \
	if (ReturnCode != SQL_SUCCESS && ReturnCode != SQL_SUCCESS_WITH_INFO) { \
		m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes); \
		pSQLDatabaseServer->HandleError(hstmt); \
		SQLFreeHandle (SQL_HANDLE_STMT,hstmt); \
		return FALSE; \
	}
#define CHECK_FOR_ERROR_FETCH \
	if (ReturnCode != SQL_SUCCESS && ReturnCode != SQL_NO_DATA) { \
		m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes); \
		pSQLDatabaseServer->HandleError(hstmt); \
		SQLFreeHandle (SQL_HANDLE_STMT,hstmt); \
		return FALSE; \
	}

#endif
